/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.workerbuildings.IBuildingPublicCrafter;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.coremod.client.gui.huts.WindowHutSifterModule;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingWorkerView;
import com.minecolonies.coremod.colony.jobs.JobSifter;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingSifter
extends AbstractBuildingWorker
implements IBuildingPublicCrafter {
    private static final double BUILDING_LEVEL_MULTIPLIER = 64.0;
    private static final String SIFTER_DESC = "sifter";
    private static final int MAX_BUILDING_LEVEL = 5;
    private int currentDailyQuantity = 0;

    public BuildingSifter(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(stack -> stack.func_77973_b().func_206844_a(ModTags.meshes), new Tuple((Object)4, (Object)false));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return SIFTER_DESC;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobSifter(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return SIFTER_DESC;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Focus;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Strength;
    }

    public void setCurrentDailyQuantity(int currentDailyQuantity) {
        this.currentDailyQuantity = currentDailyQuantity;
    }

    public int getMaxDailyQuantity() {
        if (this.getBuildingLevel() >= 5) {
            return Integer.MAX_VALUE;
        }
        return (int)(Math.pow(this.getBuildingLevel(), 2.0) * 64.0);
    }

    @Override
    public void onWakeUp() {
        super.onWakeUp();
        this.currentDailyQuantity = 0;
    }

    public int getCurrentDailyQuantity() {
        return this.currentDailyQuantity;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        this.currentDailyQuantity = compound.func_74762_e("currentDaily");
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        compound.func_74768_a("currentDaily", this.currentDailyQuantity);
        return compound;
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        super.serializeToView(buf);
        buf.writeInt(this.getMaxDailyQuantity());
        buf.writeInt(this.getCurrentDailyQuantity());
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.sifter;
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Custom {
        @Override
        @Nullable
        public IJob<?> getCraftingJob() {
            return this.getMainBuildingJob().orElseGet(() -> new JobSifter(null));
        }
    }

    public static class View
    extends AbstractBuildingWorkerView {
        private int maxDailyQuantity = 0;
        private int currentDailyQuantity = 0;

        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        public void deserialize(@NotNull PacketBuffer buf) {
            super.deserialize(buf);
            this.maxDailyQuantity = buf.readInt();
            this.currentDailyQuantity = buf.readInt();
        }

        public int getMaxDailyQuantity() {
            return this.maxDailyQuantity;
        }

        public int getCurrentDailyQuantity() {
            return this.currentDailyQuantity;
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutSifterModule(this);
        }
    }
}

